-module(quickAsy).

-export([encode/2, decode/2]).



encode(String, Key) ->
	KeyLen = length(Key),
	KeyTuple = list_to_tuple(Key),
	encode(String, KeyTuple, [], 1, KeyLen).

encode([], _KeyTuple, AccString, _Idx, _KeyLen) -> lists:reverse(lists:append(AccString));
encode([Chat|TString], KeyTuple, AccString, Idx, KeyLen) ->
	KeyIdx = Idx rem KeyLen + 1,
	KeyChat = element(KeyIdx, KeyTuple),
	EncodeChat = Chat + KeyChat,
	encode(TString, KeyTuple, [lists:reverse(integer_to_list(EncodeChat)),"@"|AccString], Idx+1, KeyLen).

decode(String, Key) ->
	KeyLen = length(Key),
	KeyTuple = list_to_tuple(Key),
	decode(string:tokens(String, "@"), KeyTuple, [], 1, KeyLen).

decode([], _KeyTuple, AccString, _Idx, _KeyLen) -> lists:reverse(AccString);
decode([Str|TStrList], KeyTuple, AccString, Idx, KeyLen) ->
	KeyIdx = Idx rem KeyLen + 1,
	KeyChat = element(KeyIdx, KeyTuple),
	DecodeChat = list_to_integer(Str) - KeyChat,
	decode(TStrList, KeyTuple, [DecodeChat|AccString], Idx+1, KeyLen).
